/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import jeresources.compatibility.CompatBase;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class MobTableBuilder {
    private final Map<ResourceKey<LootTable>, Supplier<LivingEntity>> mobTables = new HashMap<ResourceKey<LootTable>, Supplier<LivingEntity>>();

    public void add(ResourceKey<LootTable> resourceLocation, EntityType<?> entityType) {
        if (MobTableBuilder.isNonLiving(entityType) || !entityType.isEnabled(CompatBase.getLevel().enabledFeatures())) {
            return;
        }
        this.mobTables.put(resourceLocation, () -> (LivingEntity)entityType.create(CompatBase.getLevel(), EntitySpawnReason.LOAD));
    }

    public void addSheep(ResourceKey<LootTable> resourceLocation, EntityType<Sheep> entityType, DyeColor dye) {
        this.mobTables.put(resourceLocation, () -> {
            Sheep sheep = (Sheep)entityType.create(CompatBase.getLevel(), EntitySpawnReason.LOAD);
            assert (sheep != null);
            sheep.setColor(dye);
            return sheep;
        });
    }

    public Map<ResourceKey<LootTable>, Supplier<LivingEntity>> getMobTables() {
        return this.mobTables;
    }

    private static boolean isNonLiving(@NotNull EntityType<?> entityType) {
        return entityType.getCategory() == MobCategory.MISC;
    }
}

